
-- Rain parameters
kPPS = 8;               -- Number of particles generated per second
kGravity = 800 ;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("heart");
  SetBlendMode(kBlendLit);
  SetNumParticles(100);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();
StopSpouting = NewTimeout(1500);
TestDone = NewTimeout(3000);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitPosition( "vRange", Vec3(-40, -40, 0), Vec3(40, 40, 0) );
   InitVelocity( "vRadius", 10)
   InitScale( "fRange", 0.1, .2 );
   InitAge("iRange", 0, 0);
   CreateParticles(newParticles);
  end

   Do("move");
   DoAge("iAge");
   DoColor("cFade",
      Color(1, 1, 1, 1), 1500,
      Color(1, 1, 1, 0), 1500,
      Color(.2, .2, .2, 0));
   DoScale("fScale",
      .25, 1500,
      .1, 500);
   Do("expire", 2000)

--DoUp( "vRotate", -.5, .5 );


end

